﻿var webspaces = {
    context: $(".v-webspaces"),
    datatable: null,
    treeview: null,
    getSelectedFolderId: function () {
        var folder = webspaces.treeview.a4listview("getHighlightedNode");
        return folder ? (folder.Id || 0) : 0;
    },
    initializeDataTable: function (folderId) {
        this.datatable = $(".h-webspacesTable", this.context).a4datatable({
            height: "full",
            ajaxAction: a4.getAction("GetWebSpaces", "MultiMode", "Settings"),
            ajaxParams: { "folderId": folderId },
            columns: [
                { "Title": resources.Id, "Data": "Id", "Key": true },
                { "Title": resources.Name, "Data": "Name", "HideInSelector": true },
                { "Name": "Status", "Title": resources.Status, "Data": "StatusEnum", "Class": "no-wrap", "Type": "enum", "EnumType": "SurveyStatus" },
                { "Title": resources.WebServerName, "Data": "WebServerName" },
                { "Title": resources.Folder, "Data": "FolderName" }
            ],
            stateKey: "WebSpaces",
            advancedFilter: true,
            allowRowSelection: "[Status]==1",
            toolBarItems: [
                { "Action": "delete", "Label": resources.Delete, "DisplayCondition": function (data) { return data.Status == 1 && voxco.security.has('DELETE', data.Permissions); } }
            ],
            contextMenuItems: [
                {
                    "Label": resources.Diagnostics,
                    "DisplayCondition": function (data) { return voxco.security.has('STORE_VIEW_LOG', data.Permissions); },
                    "SubMenuItems": [
                        { "Action": "stats", "Label": resources.ServerStatistics },
                        { "Action": "cawiLogs", "Label": resources.CAWILogs },
                        { "Action": "errors", "Label": resources.ErrorLogs }
                    ]
                },
                { "Divider": true },
                {
                    "Action": "delete", "Label": resources.Delete,
                    "DisplayCondition": function (data) { return voxco.security.has('DELETE', data.Permissions) && data.Status == 1; }
                },
                {
                    "Action": "properties", "Label": resources.Properties,
                    "DisplayCondition": function (data) { return voxco.security.has('READ', data.Permissions); }
                },
                { "Divider": true },
                {
                    "Action": "activate", "Label": resources.Activate,
                    "DisplayCondition": function (data) { return voxco.security.has('START_STOP', data.Permissions) && data.Status == 1; }
                },
                {
                    "Action": "stop", "Label": resources.Stop,
                    "DisplayCondition": function (data) { return voxco.security.has('START_STOP', data.Permissions) && data.Status == 3; }
                }
            ],
            contextMenuClick: function (event, data) {
                var row = data.row;
                var action = data.action;

                var row = data.row;
                var action = data.action;

                switch (action) {
                    case "delete":
                        webspaces.deleteWebSpaces([row.Id]);
                        break;
                    case "properties":
                        modalDialog.showWindow(a4.getAction("EditWebSpace", "MultiMode", "Settings", { id: row.Id }), 450, 700, { afterClose: function () { webspaces.refreshContent(); } });
                        break;
                    case "activate":
                        webspaces.startWebSpace(row.Id);
                        break;
                    case "stop":
                        webspaces.stopWebSpace(row.Id);
                        break;
                    case "stats":
                        modalDialog.showWindow(a4.getAction("WebSpaceServerStatistics", "MultiMode", "Settings", { id: row.Id }), "90%", "90%");
                        break;
                    case "cawiLogs":
                        modalDialog.showWindow(a4.getAction("CAWIConnectionsLogs", "MultiMode", "Settings", { id: row.Id }), "90%", "90%");
                        break;
                    case "errors":
                        modalDialog.showWindow(a4.getAction("WebSpaceErrorLogs", "MultiMode", "Settings", { id: row.Id }), "90%", "90%");
                        break;
                }
            },
            toolBarClick: function (event, data) {
                var rows = data.rows;
                var action = data.action;
                var ids = _.pluck(rows, "Id");

                if (action == "delete") {
                    webspaces.deleteWebSpaces(ids);
                }
            },
            localizableTexts: { "Search": resources.SearchWebSpaces }
        });
    },
    initializeTreeView: function () {
        this.treeview = $(".h-webspaceFolders", this.context).a4listview({
            ajaxAction: a4.getAction("GetWebSpaceFolders", "MultiMode", "Settings"),
            stateKey: "WebSpaces",
            draw: function (event, data) {
                var folder = data.selectedNode;
                var folderId = folder ? (folder.Id || 0) : 0;

                if (webspaces.datatable) {
                    webspaces.datatable.a4datatable("option", "ajaxParams", { "folderId": folderId });
                    webspaces.datatable.a4datatable("refresh");
                }
                else {
                    webspaces.initializeDataTable(folderId);
                }

                webspaces.selectNodeCallback(folder);

                $(".main-content", webspaces.context).toggleClass("full-width", data.count > 1)
                $(".v-tableContainer", webspaces.context).toggleClass("right-panel", data.count > 1);
                $(this).toggle(data.count > 1);


            },
            selectNode: function (event, data) {
                webspaces.datatable.a4datatable("option", "ajaxParams", { "folderId": data.node.Id });
                webspaces.datatable.a4datatable("refresh", true);

                webspaces.selectNodeCallback(data.node);
            },
            actionButtons: [
                {
                    Action: "activate", Label: resources.Activate, Icon: "activate",
                    "DisplayCondition": function (data) { return data.Status == 1 && voxco.security.has('START_STOP_GROUP', data.Permissions); }
                },
                {
                    Action: "stop", Label: resources.Stop, Icon: "deactivate",
                    "DisplayCondition": function (data) { return data.Status == 3 && voxco.security.has('START_STOP_GROUP', data.Permissions); }
                },
                {
                    Action: "properties", Label: resources.Properties, Icon: "edit",
                    "DisplayCondition": function (data) { return data.ParentId > 0 && voxco.security.has('READ_GROUP', data.Permissions); }
                },
                {
                    Action: "delete", Label: resources.Delete, Icon: "remove",
                    "DisplayCondition": function (data) { return data.Status == 1 && voxco.security.has('DELETE_GROUP', data.Permissions); }
                }
            ],
            actionButtonClick: function (event, data) {
                var action = data.action;
                var node = data.node;

                switch (action) {
                    case "activate":
                        webspaces.startFolder(node.Id, node.Name);
                        break;
                    case "stop":
                        webspaces.stopFolder(node.Id, node.Name);
                        break;
                    case "properties":
                        modalDialog.showWindow(a4.getAction("WebSpaceFolderProperties", "MultiMode", "Settings", { id: node.Id }), 220, 600, { afterClose: function () { webspaces.refreshContent(); } });
                        break;
                    case "delete":
                        webspaces.deleteFolder(node.Id);
                        break;
                }
            },
            localizableTexts: { "Search": resources.SearchWebSpaceFolders },
            highlightFirstNode: true
        });
    },
    selectNodeCallback: function (folder) {
        if (folder) {
            var menu = $("#main-header .h-newWebSpaceMenu", webspaces.context);

            var canCreateChild = voxco.security.has('CREATE', folder.Permissions);
            $(".h-newWebSpace", menu).toggle(canCreateChild);

            var canCreateFolder = voxco.security.has('CREATE_GROUP', folder.Permissions);
            $(".h-newWebSpaceFolder", menu).toggle(canCreateFolder);

            menu.toggle(canCreateChild || canCreateFolder);
        }
    },
    bindEvents: function () {
        $(".h-newWebSpaceMenu").on("click", "li.h-newWebSpace", function () {
            modalDialog.showWindow(a4.getAction("EditWebSpace", "MultiMode", "Settings", { folderId: webspaces.getSelectedFolderId() }), 450, 700, { afterClose: function () { webspaces.refreshContent(); } });
        });

        $(".h-newWebSpaceMenu").on("click", "li.h-newWebSpaceFolder", function () {
            modalDialog.showWindow(a4.getAction("WebSpaceFolderProperties", "MultiMode", "Settings", { parentId: webspaces.getSelectedFolderId() }), 250, 600, { afterClose: function () { webspaces.refreshContent(); } });
        });
    },
    deleteFolder: function (id) {
        modalDialog.showConfirmDelete(confirmDeleteWebSpacesFoldersResources, function () {
            a4.callServerMethod(a4.getAction("DeleteWebSpaceFolder", "MultiMode", "Settings"), { id: id },
                function (result) {
                    webspaces.refreshContent();
                });
        }, 1);
    },
    deleteWebSpaces: function (ids) {
        modalDialog.showConfirmDelete(confirmDeleteWebSpacesResources, function () {
            a4.callServerMethod(a4.getAction("DeleteWebSpaces", "MultiMode", "Settings"), { ids: ids },
                function (result) {
                    webspaces.refreshContent();
                });
        }, ids.length);
    },
    refreshContent: function () {
        webspaces.treeview.a4listview("refresh");
    },
    startFolder: function (folderId, folderName) {
        modalDialog.showConfirmDialog(confirmActivateFolderResources, function () {
            a4.callServerMethod(a4.getAction("StartWebSpaceFolder", "MultiMode", "Settings"), { folderId: folderId }, function (result) {
                webspaces.refreshContent();
            });
        }, null, null, false, { "folder": folderName });
    },
    stopFolder: function (folderId, folderName) {
        modalDialog.showConfirmDialog(confirmStopFolderResources, function () {
            a4.callServerMethod(a4.getAction("StopWebSpaceFolder", "MultiMode", "Settings"), { folderId: folderId }, function (result) {
                webspaces.refreshContent();
            });
        }, null, null, false, { "folder": folderName });
    },
    startWebSpace: function (id) {
        a4.callServerMethod(a4.getAction("StartWebSpace", "MultiMode", "Settings"), { id: id }, function (result) {
            webspaces.refreshContent();
        });
    },
    stopWebSpace: function (id) {
        a4.callServerMethod(a4.getAction("StopWebSpace", "MultiMode", "Settings"), { id: id }, function (result) {
            webspaces.refreshContent();
        });
    }
}

$(document).ready(function () {
    if (webspaces.context.length > 0) {
        webspaces.initializeTreeView();
        webspaces.bindEvents();
    }
});